require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartWherigoASPOldZoo = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartWherigoASPOldZoo.MsgBoxCBFuncs = {}

zmediaRangerTom = Wherigo.ZMedia(cartWherigoASPOldZoo)
zmediaRangerTom.Name="Ranger Tom"
zmediaRangerTom.Description=""
zmediaRangerTom.AltText=""
zmediaRangerTom.Id="d1fa4275-cd2c-4076-aac9-814f3518e8d1"
zmediaRangerTom.Resources = {
{ Type = "jpg", Filename = "rangersmith resize.jpg", Directives = {},},
}
zmediaRaccoon = Wherigo.ZMedia(cartWherigoASPOldZoo)
zmediaRaccoon.Name="Raccoon"
zmediaRaccoon.Description=""
zmediaRaccoon.AltText=""
zmediaRaccoon.Id="b6ee32a3-5800-41d4-85ea-ba468b2d610e"
zmediaRaccoon.Resources = {
{ Type = "jpg", Filename = "raccoon resize.jpg", Directives = {},},
}
zmediaSquirrel = Wherigo.ZMedia(cartWherigoASPOldZoo)
zmediaSquirrel.Name="Squirrel"
zmediaSquirrel.Description=""
zmediaSquirrel.AltText=""
zmediaSquirrel.Id="7ec631f1-0835-4767-b8b5-666bc1df188b"
zmediaSquirrel.Resources = {
{ Type = "jpg", Filename = "squirrelEating resize.jpg", Directives = {},},
}
zmediaBear = Wherigo.ZMedia(cartWherigoASPOldZoo)
zmediaBear.Name="Bear"
zmediaBear.Description=""
zmediaBear.AltText=""
zmediaBear.Id="18807caa-d343-4654-8e0f-3effbd7219a5"
zmediaBear.Resources = {
{ Type = "jpg", Filename = "bear resize.jpg", Directives = {},},
}
zmediaowl = Wherigo.ZMedia(cartWherigoASPOldZoo)
zmediaowl.Name="owl"
zmediaowl.Description=""
zmediaowl.AltText=""
zmediaowl.Id="0e048ee7-5cea-4a75-94f2-1fa54408c6d6"
zmediaowl.Resources = {
{ Type = "jpg", Filename = "Saw-whet_Owl resize 2.jpg", Directives = {},},
}
zmediaDeer = Wherigo.ZMedia(cartWherigoASPOldZoo)
zmediaDeer.Name="Deer"
zmediaDeer.Description=""
zmediaDeer.AltText=""
zmediaDeer.Id="fe7c98fb-2bc1-4ae1-85a5-7ed369d08b55"
zmediaDeer.Resources = {
{ Type = "jpg", Filename = "deer resized.jpg", Directives = {},},
}
-- Cartridge Info --
cartWherigoASPOldZoo.Id="34f387ae-1df0-43fa-a5e4-20db0d5f42c2"
cartWherigoASPOldZoo.Name="Wherigo ASP Old Zoo"
cartWherigoASPOldZoo.Description=[[A beginner level wherigo cache that takes the player on a tour of the Old Zoo area at Allegany State Park.]]
cartWherigoASPOldZoo.Visible=true
cartWherigoASPOldZoo.Activity="Geocache"
cartWherigoASPOldZoo.StartingLocationDescription=[[Near the parking area for the administration building. The starting point is at the memrial stone for Albert T. Fancher, the first chairman of the Allegany State Park commission.]]
cartWherigoASPOldZoo.StartingLocation = ZonePoint(42.1003666639328,-78.7497666676839,0)
cartWherigoASPOldZoo.Version="1.0"
cartWherigoASPOldZoo.Company=""
cartWherigoASPOldZoo.Author="MickEMT"
cartWherigoASPOldZoo.BuilderVersion="2.0.5129.5086"
cartWherigoASPOldZoo.CreateDate="5/6/2009 5:29:19 AM"
cartWherigoASPOldZoo.PublishDate="1/1/0001 12:00:00 AM"
cartWherigoASPOldZoo.UpdateDate="5/11/2009 8:50:34 AM"
cartWherigoASPOldZoo.LastPlayedDate="1/1/0001 12:00:00 AM"
cartWherigoASPOldZoo.TargetDevice="PocketPC"
cartWherigoASPOldZoo.TargetDeviceVersion="0"
cartWherigoASPOldZoo.StateId="1"
cartWherigoASPOldZoo.CountryId="2"
cartWherigoASPOldZoo.Complete=false
cartWherigoASPOldZoo.UseLogging=true

-- Zones --
zoneWeatherStation = Wherigo.Zone(cartWherigoASPOldZoo)
zoneWeatherStation.Id="63e19aa8-2d0a-458f-a68a-2d67f7f8fece"
zoneWeatherStation.Name="Weather Station"
zoneWeatherStation.Description=[[]]
zoneWeatherStation.Visible=false
zoneWeatherStation.DistanceRange = Distance(1500, "feet")
zoneWeatherStation.ShowObjects="OnProximity"
zoneWeatherStation.ProximityRange = Distance(20, "feet")
zoneWeatherStation.AllowSetPositionTo=false
zoneWeatherStation.Active=false
zoneWeatherStation.Points = {
  ZonePoint(42.10035,-78.75001,0),
  ZonePoint(42.10035,-78.74996,0),
  ZonePoint(42.10031,-78.74996,0),
  ZonePoint(42.10031,-78.75001,0)
}
zoneWeatherStation.OriginalPoint = ZonePoint(42.1003333330154,-78.7499833424886,0)
zoneWeatherStation.DistanceRangeUOM = "Feet"
zoneWeatherStation.ProximityRangeUOM = "Feet"
zoneWeatherStation.OutOfRangeName = ""
zoneWeatherStation.InRangeName = ""

zoneZooSign = Wherigo.Zone(cartWherigoASPOldZoo)
zoneZooSign.Id="2df4ce3b-419f-4e44-bf0f-f0cbfd356743"
zoneZooSign.Name="Zoo Sign"
zoneZooSign.Description=[[]]
zoneZooSign.Visible=false
zoneZooSign.DistanceRange = Distance(1500, "feet")
zoneZooSign.ShowObjects="OnProximity"
zoneZooSign.ProximityRange = Distance(20, "feet")
zoneZooSign.AllowSetPositionTo=false
zoneZooSign.Active=false
zoneZooSign.Points = {
  ZonePoint(42.10054,-78.75041,0),
  ZonePoint(42.10054,-78.75036,0),
  ZonePoint(42.1005,-78.75036,0),
  ZonePoint(42.1005,-78.75041,0)
}
zoneZooSign.OriginalPoint = ZonePoint(42.1005166689555,-78.7503833134969,0)
zoneZooSign.DistanceRangeUOM = "Feet"
zoneZooSign.ProximityRangeUOM = "Feet"
zoneZooSign.OutOfRangeName = ""
zoneZooSign.InRangeName = ""

zoneBearCave = Wherigo.Zone(cartWherigoASPOldZoo)
zoneBearCave.Id="e6685b88-d608-404c-aafd-6fe80bf7cc8b"
zoneBearCave.Name="Bear Cave"
zoneBearCave.Description=[[]]
zoneBearCave.Visible=false
zoneBearCave.DistanceRange = Distance(1500, "feet")
zoneBearCave.ShowObjects="OnProximity"
zoneBearCave.ProximityRange = Distance(25, "feet")
zoneBearCave.AllowSetPositionTo=false
zoneBearCave.Active=false
zoneBearCave.Points = {
  ZonePoint(42.10044,-78.75055,0),
  ZonePoint(42.10044,-78.75048,0),
  ZonePoint(42.10039,-78.75048,0),
  ZonePoint(42.10039,-78.75055,0)
}
zoneBearCave.OriginalPoint = ZonePoint(42.1004166682561,-78.7505166371663,0)
zoneBearCave.DistanceRangeUOM = "Feet"
zoneBearCave.ProximityRangeUOM = "Feet"
zoneBearCave.OutOfRangeName = ""
zoneBearCave.InRangeName = ""

zoneZooRuins = Wherigo.Zone(cartWherigoASPOldZoo)
zoneZooRuins.Id="554704d3-8e2a-4ae2-91c3-568b2224308b"
zoneZooRuins.Name="Zoo Ruins"
zoneZooRuins.Description=[[]]
zoneZooRuins.Visible=false
zoneZooRuins.DistanceRange = Distance(1500, "feet")
zoneZooRuins.ShowObjects="OnProximity"
zoneZooRuins.ProximityRange = Distance(20, "feet")
zoneZooRuins.AllowSetPositionTo=false
zoneZooRuins.Active=false
zoneZooRuins.Points = {
  ZonePoint(42.1007,-78.75058,0),
  ZonePoint(42.1007,-78.75052,0),
  ZonePoint(42.10066,-78.75052,0),
  ZonePoint(42.10066,-78.75058,0)
}
zoneZooRuins.OriginalPoint = ZonePoint(42.1006833314896,-78.7505500157674,0)
zoneZooRuins.DistanceRangeUOM = "Feet"
zoneZooRuins.ProximityRangeUOM = "Feet"
zoneZooRuins.OutOfRangeName = ""
zoneZooRuins.InRangeName = ""

zoneFinalArea = Wherigo.Zone(cartWherigoASPOldZoo)
zoneFinalArea.Id="100ab64c-ad01-41ec-bde5-c1a9c8fe881f"
zoneFinalArea.Name="Final Area"
zoneFinalArea.Description=[[]]
zoneFinalArea.Visible=false
zoneFinalArea.DistanceRange = Distance(1500, "feet")
zoneFinalArea.ShowObjects="OnProximity"
zoneFinalArea.ProximityRange = Distance(35, "feet")
zoneFinalArea.AllowSetPositionTo=false
zoneFinalArea.Active=false
zoneFinalArea.Points = {
  ZonePoint(42.1006,-78.75121,0),
  ZonePoint(42.1006,-78.75112,0),
  ZonePoint(42.10053,-78.75112,0),
  ZonePoint(42.10053,-78.75121,0)
}
zoneFinalArea.OriginalPoint = ZonePoint(42.1005666653315,-78.7511666615804,0)
zoneFinalArea.DistanceRangeUOM = "Feet"
zoneFinalArea.ProximityRangeUOM = "Feet"
zoneFinalArea.OutOfRangeName = ""
zoneFinalArea.InRangeName = ""

zoneTrailSigns = Wherigo.Zone(cartWherigoASPOldZoo)
zoneTrailSigns.Id="d7a14f44-c9c3-4f32-be17-1a10a2ded0ba"
zoneTrailSigns.Name="Trail Signs"
zoneTrailSigns.Description=[[]]
zoneTrailSigns.Visible=false
zoneTrailSigns.DistanceRange = Distance(1500, "feet")
zoneTrailSigns.ShowObjects="OnProximity"
zoneTrailSigns.ProximityRange = Distance(20, "feet")
zoneTrailSigns.AllowSetPositionTo=false
zoneTrailSigns.Active=false
zoneTrailSigns.Points = {
  ZonePoint(42.10095,-78.75051,0),
  ZonePoint(42.10095,-78.75046,0),
  ZonePoint(42.10091,-78.75046,0),
  ZonePoint(42.10091,-78.75051,0)
}
zoneTrailSigns.OriginalPoint = ZonePoint(42.1009333372116,-78.7504833221436,0)
zoneTrailSigns.DistanceRangeUOM = "Feet"
zoneTrailSigns.ProximityRangeUOM = "Feet"
zoneTrailSigns.OutOfRangeName = ""
zoneTrailSigns.InRangeName = ""

-- Characters --
zcharacterRangerTom = Wherigo.ZCharacter{Cartridge=cartWherigoASPOldZoo, Container=zoneWeatherStation}
zcharacterRangerTom.Id="d20d9f36-11d7-435f-b42f-d39be6630514"
zcharacterRangerTom.Name="Ranger Tom"
zcharacterRangerTom.Description=[[]]
zcharacterRangerTom.Visible=false
zcharacterRangerTom.Media=zmediaRangerTom
zcharacterRangerTom.Gender="Male"
zcharacterRangerTom.Type="NPC"
zcharacterRangerTom.ObjectLocation = ZonePoint(42.1005723095552,-78.751170316001,360)
zcharacterRangerTom.Commands = {
  GiveCodeWord = Wherigo.ZCommand{Text="Give Code Word", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zcharacterRangerTom.Commands.GiveCodeWord.Custom = true
zcharacterRangerTom.Commands.GiveCodeWord.Id="0f8eb6ab-ed18-4845-9a70-b26a0a025c08"
zcharacterRangerTom.Commands.GiveCodeWord.WorksWithAll = true

zcharacterMommaBear = Wherigo.ZCharacter{Cartridge=cartWherigoASPOldZoo, Container=zoneBearCave}
zcharacterMommaBear.Id="7b1a2ee5-5378-482e-afe0-7a032ae7b4b9"
zcharacterMommaBear.Name="Momma Bear"
zcharacterMommaBear.Description=[[]]
zcharacterMommaBear.Visible=false
zcharacterMommaBear.Media=zmediaBear
zcharacterMommaBear.Gender="Male"
zcharacterMommaBear.Type="NPC"
zcharacterMommaBear.ObjectLocation = ZonePoint(42.1004208253389,-78.7505202371498,360)
zcharacterMommaBear.Commands = {
  TalkTo = Wherigo.ZCommand{Text="Talk To", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zcharacterMommaBear.Commands.TalkTo.Custom = true
zcharacterMommaBear.Commands.TalkTo.Id="95170ebb-ae65-4972-acd9-751d4d330556"
zcharacterMommaBear.Commands.TalkTo.WorksWithAll = true

zcharacterRaccoon = Wherigo.ZCharacter{Cartridge=cartWherigoASPOldZoo, Container=zoneWeatherStation}
zcharacterRaccoon.Id="6dd24e55-914e-4534-bf21-b719a026d12b"
zcharacterRaccoon.Name="Raccoon"
zcharacterRaccoon.Description=[[]]
zcharacterRaccoon.Visible=false
zcharacterRaccoon.Media=zmediaRaccoon
zcharacterRaccoon.Gender="Male"
zcharacterRaccoon.Type="NPC"
zcharacterRaccoon.ObjectLocation = ZonePoint(42.1003311384715,-78.7499901583533,360)
zcharacterRaccoon.Commands = {
  TalkTo = Wherigo.ZCommand{Text="Talk To", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zcharacterRaccoon.Commands.TalkTo.Custom = true
zcharacterRaccoon.Commands.TalkTo.Id="9bcce244-c0f2-4c6e-bb31-5e8df14f4710"
zcharacterRaccoon.Commands.TalkTo.WorksWithAll = true

zcharacterDeer = Wherigo.ZCharacter{Cartridge=cartWherigoASPOldZoo, Container=zoneTrailSigns}
zcharacterDeer.Id="9bf3f312-65ce-49dd-aea0-d1fe278de9eb"
zcharacterDeer.Name="Deer"
zcharacterDeer.Description=[[]]
zcharacterDeer.Visible=false
zcharacterDeer.Media=zmediaDeer
zcharacterDeer.Gender="Male"
zcharacterDeer.Type="NPC"
zcharacterDeer.ObjectLocation = ZonePoint(42.1009311384714,-78.7504901584003,360)
zcharacterDeer.Commands = {
  TalkTo = Wherigo.ZCommand{Text="Talk To", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zcharacterDeer.Commands.TalkTo.Custom = true
zcharacterDeer.Commands.TalkTo.Id="936866c3-760a-4976-ae39-a4190bf8ed74"
zcharacterDeer.Commands.TalkTo.WorksWithAll = true

zcharacterOwl = Wherigo.ZCharacter{Cartridge=cartWherigoASPOldZoo, Container=zoneZooRuins}
zcharacterOwl.Id="542357fe-1e36-454a-8ae0-554b25eb9aa8"
zcharacterOwl.Name="Owl"
zcharacterOwl.Description=[[]]
zcharacterOwl.Visible=false
zcharacterOwl.Media=zmediaowl
zcharacterOwl.Gender="Male"
zcharacterOwl.Type="NPC"
zcharacterOwl.ObjectLocation = ZonePoint(42.1006811384715,-78.7505500013279,360)
zcharacterOwl.Commands = {
  TalkTo = Wherigo.ZCommand{Text="Talk To", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zcharacterOwl.Commands.TalkTo.Custom = true
zcharacterOwl.Commands.TalkTo.Id="422e86db-1eac-4776-bc9f-6fefa94a88ec"
zcharacterOwl.Commands.TalkTo.WorksWithAll = true

zcharacterSquirrel = Wherigo.ZCharacter{Cartridge=cartWherigoASPOldZoo, Container=zoneZooSign}
zcharacterSquirrel.Id="b42e9565-3165-4eda-bb9b-b0a9e6b23085"
zcharacterSquirrel.Name="Squirrel"
zcharacterSquirrel.Description=[[]]
zcharacterSquirrel.Visible=false
zcharacterSquirrel.Media=zmediaSquirrel
zcharacterSquirrel.Gender="Male"
zcharacterSquirrel.Type="NPC"
zcharacterSquirrel.ObjectLocation = ZonePoint(42.1005211384715,-78.7503901583682,360)
zcharacterSquirrel.Commands = {
  TalkTo = Wherigo.ZCommand{Text="Talk To", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zcharacterSquirrel.Commands.TalkTo.Custom = true
zcharacterSquirrel.Commands.TalkTo.Id="76890b94-aab1-47f1-ad19-d8614f287ef9"
zcharacterSquirrel.Commands.TalkTo.WorksWithAll = true

-- Items --

-- Tasks --
ztaskFinalTask = Wherigo.ZTask(cartWherigoASPOldZoo)
ztaskFinalTask.Id="ee0a9dfc-b9a6-4269-aee6-0fe7f568dbca"
ztaskFinalTask.Name="Final Task"
ztaskFinalTask.Description=[[]]
ztaskFinalTask.Visible=false
ztaskFinalTask.Active=false
ztaskFinalTask.Complete=false
ztaskFinalTask.CorrectState = "None"

ztaskweathertask = Wherigo.ZTask(cartWherigoASPOldZoo)
ztaskweathertask.Id="73396e05-1db3-4cdc-b433-7c176778887e"
ztaskweathertask.Name="weather task"
ztaskweathertask.Description=[[]]
ztaskweathertask.Visible=false
ztaskweathertask.Active=false
ztaskweathertask.Complete=false
ztaskweathertask.CorrectState = "None"

ztaskzoosigntask = Wherigo.ZTask(cartWherigoASPOldZoo)
ztaskzoosigntask.Id="7835ac0f-a438-4b9f-9894-de1d5adab694"
ztaskzoosigntask.Name="zoo sign task"
ztaskzoosigntask.Description=[[]]
ztaskzoosigntask.Visible=false
ztaskzoosigntask.Active=false
ztaskzoosigntask.Complete=false
ztaskzoosigntask.CorrectState = "None"

ztaskbeardentask = Wherigo.ZTask(cartWherigoASPOldZoo)
ztaskbeardentask.Id="06b81c07-aad4-40c1-82fa-8b5063837fe2"
ztaskbeardentask.Name="bear den task"
ztaskbeardentask.Description=[[]]
ztaskbeardentask.Visible=false
ztaskbeardentask.Active=false
ztaskbeardentask.Complete=false
ztaskbeardentask.CorrectState = "None"

ztasktrailsigntask = Wherigo.ZTask(cartWherigoASPOldZoo)
ztasktrailsigntask.Id="3140e8b0-a3b6-4742-9cc3-ce16cbb5c9e7"
ztasktrailsigntask.Name="trail sign task"
ztasktrailsigntask.Description=[[]]
ztasktrailsigntask.Visible=false
ztasktrailsigntask.Active=false
ztasktrailsigntask.Complete=false
ztasktrailsigntask.CorrectState = "None"

ztaskzooruintask = Wherigo.ZTask(cartWherigoASPOldZoo)
ztaskzooruintask.Id="87e94688-890e-4ebc-9f93-cbd1ce88a930"
ztaskzooruintask.Name="zoo ruin task"
ztaskzooruintask.Description=[[]]
ztaskzooruintask.Visible=false
ztaskzooruintask.Active=false
ztaskzooruintask.Complete=false
ztaskzooruintask.CorrectState = "None"

-- Cartridge Variables --
trailsignvariable = ""
zooruinsvariable = 0
FinalVariable = ""
WeatherStationVariable = ""
bearcavevariable = ""
zoosignvariable = 0
cartWherigoASPOldZoo.ZVariables = {trailsignvariable = "", zooruinsvariable = 0, FinalVariable = "", WeatherStationVariable = "", bearcavevariable = "", zoosignvariable = 0}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.trailsignvariable = {}
buildervar.trailsignvariable.Id ="0c0df81c-ad3a-4d0e-ba96-0545ff081e84"
buildervar.trailsignvariable.Name = "trail sign variable"
buildervar.trailsignvariable.Type = "String"
buildervar.trailsignvariable.Data=[[]]
buildervar.trailsignvariable.Description=[[]]

buildervar.zooruinsvariable = {}
buildervar.zooruinsvariable.Id ="3d91bad9-6aaf-4add-b552-16d251ee8c10"
buildervar.zooruinsvariable.Name = "zoo ruins variable"
buildervar.zooruinsvariable.Type = "Number"
buildervar.zooruinsvariable.Data=[[0]]
buildervar.zooruinsvariable.Description=[[]]

buildervar.FinalVariable = {}
buildervar.FinalVariable.Id ="6a210f6a-4bf1-4782-940d-a298339cd125"
buildervar.FinalVariable.Name = "Final Variable"
buildervar.FinalVariable.Type = "String"
buildervar.FinalVariable.Data=[[]]
buildervar.FinalVariable.Description=[[]]

buildervar.WeatherStationVariable = {}
buildervar.WeatherStationVariable.Id ="5082c5e6-814d-4b93-ba11-42e27dcf65c0"
buildervar.WeatherStationVariable.Name = "Weather Station Variable"
buildervar.WeatherStationVariable.Type = "String"
buildervar.WeatherStationVariable.Data=[[]]
buildervar.WeatherStationVariable.Description=[[]]

buildervar.bearcavevariable = {}
buildervar.bearcavevariable.Id ="08dbb209-0161-4256-a44e-26a57272afa5"
buildervar.bearcavevariable.Name = "bear cave variable"
buildervar.bearcavevariable.Type = "String"
buildervar.bearcavevariable.Data=[[]]
buildervar.bearcavevariable.Description=[[]]

buildervar.zoosignvariable = {}
buildervar.zoosignvariable.Id ="9e80f353-5fe5-4939-b2f9-a3a4f28f886d"
buildervar.zoosignvariable.Name = "zoo sign variable"
buildervar.zoosignvariable.Type = "Number"
buildervar.zoosignvariable.Data=[[0]]
buildervar.zoosignvariable.Description=[[]]


-- ZTimers --

-- Inputs --
zinputFinalInput = Wherigo.ZInput(cartWherigoASPOldZoo)
zinputFinalInput.Id="7e021153-a7e7-4cad-b8ab-1514c7a67cfd"
zinputFinalInput.Name="Final Input"
zinputFinalInput.Description=[[]]
zinputFinalInput.Visible=true
zinputFinalInput.InputType="Text"
zinputFinalInput.InputVariableId="6a210f6a-4bf1-4782-940d-a298339cd125"
zinputFinalInput.Text=[[What was the code word from inside the logbook cover.]]

zinputWeatherStationInput = Wherigo.ZInput(cartWherigoASPOldZoo)
zinputWeatherStationInput.Id="20c4c59b-f13c-4239-bd34-2a9c2e92ba63"
zinputWeatherStationInput.Name="Weather Station Input"
zinputWeatherStationInput.Description=[[]]
zinputWeatherStationInput.Visible=true
zinputWeatherStationInput.InputType="Text"
zinputWeatherStationInput.InputVariableId="5082c5e6-814d-4b93-ba11-42e27dcf65c0"
zinputWeatherStationInput.Text=[[What one word weather phenomenon happened at the park on August 28 1990 ]]

zinputzoosigninput = Wherigo.ZInput(cartWherigoASPOldZoo)
zinputzoosigninput.Id="bc47384f-63c1-43c8-9f15-cc62db04c718"
zinputzoosigninput.Name="zoo sign input"
zinputzoosigninput.Description=[[]]
zinputzoosigninput.Visible=true
zinputzoosigninput.InputType="Text"
zinputzoosigninput.InputVariableId="9e80f353-5fe5-4939-b2f9-a3a4f28f886d"
zinputzoosigninput.Text=[[The outdoor museum was built by company number what of the C.C.C.]]

zinputtrailsigninput = Wherigo.ZInput(cartWherigoASPOldZoo)
zinputtrailsigninput.Id="d7c143a7-490d-4130-9199-18a035c0b210"
zinputtrailsigninput.Name="trail sign input"
zinputtrailsigninput.Description=[[]]
zinputtrailsigninput.Visible=true
zinputtrailsigninput.InputType="Text"
zinputtrailsigninput.InputVariableId="0c0df81c-ad3a-4d0e-ba96-0545ff081e84"
zinputtrailsigninput.Text=[[What trail is the old ski jump on?]]

zinputzooruinsinput = Wherigo.ZInput(cartWherigoASPOldZoo)
zinputzooruinsinput.Id="b99087ad-fbed-49ac-b8f4-c17d1b971a56"
zinputzooruinsinput.Name="zoo ruins input"
zinputzooruinsinput.Description=[[]]
zinputzooruinsinput.Visible=true
zinputzooruinsinput.InputType="Text"
zinputzooruinsinput.InputVariableId="3d91bad9-6aaf-4add-b552-16d251ee8c10"
zinputzooruinsinput.Text=[[What year was the outdoor museum opened?]]

zinputbearcaveinput = Wherigo.ZInput(cartWherigoASPOldZoo)
zinputbearcaveinput.Id="b84e875d-e8fe-48bd-bef3-096ffbe67527"
zinputbearcaveinput.Name="bear cave input"
zinputbearcaveinput.Description=[[]]
zinputbearcaveinput.Visible=true
zinputbearcaveinput.InputType="Text"
zinputbearcaveinput.InputVariableId="08dbb209-0161-4256-a44e-26a57272afa5"
zinputbearcaveinput.Text=[[The first bears to use the den were Cubby and who]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function cartWherigoASPOldZoo:OnStart()
-- #GroupDescription=start cart --
-- #Comment=start cart Comment --
zcharacterRangerTom.Commands["GiveCodeWord"].Enabled = false
Wherigo.MessageBox{Text=[[Welcome to the ASP Old Zoo Wherigo cache. This cartridge will take you on a tour of the old zoo area  of the park before leading you to the cache.  I strongly suggest that you carefully read the interpritive signs at three of the stops, as they WILL contain information that you will need to complete the cache. Now, click OK and head up the steps and to your left to the weather station to meet your tourguide, Ranger Tom and start your adventure.]],}
ztaskweathertask.Active = true
zoneWeatherStation.Active = true
zoneWeatherStation.Visible = true
end

function zoneWeatherStation:OnProximity()
-- #GroupDescription=weather prox --
-- #Comment=weather prox Comment --
zcharacterRaccoon.Visible = true
Wherigo.MessageBox{Text=[[Hi, I'm Ranger Tom, and I'll be your guide on our tour of the old zoo here at Allegany State Park today. As we go along, please make sure to carefully read the informational signs at each stop as they contain the answers you will need. At each stop, you will eet an animal that is native to the park, each one will have a question that you must answer correctly to contine.  Now, after you read the sign here at our weather station, talk to the raccoon for your first question.]],Media=zmediaRangerTom,}
end

function zcharacterRaccoon:OnTalkTo()
-- #GroupDescription=raccoon talk --
-- #Comment=raccoon talk Comment --
Wherigo.GetInput(zinputWeatherStationInput)
end

function zinputWeatherStationInput:OnGetInput(input)
WeatherStationVariable = input
-- #GroupDescription=weather input --
-- #Comment=weather input Comment --
if   Wherigo.NoCaseEquals(WeatherStationVariable,"Tornado") then
ztaskweathertask.Complete = true
ztaskweathertask.Active = false
Wherigo.MessageBox{Text=[[That's right! Allegany State Park has had some wild weather, you can visit the tornado site off of ASP Route 1. Now head on over to the information sign for the zoo and Ranger Tom will tell you what comes next.]],Media=zmediaRaccoon,}
zoneZooSign.Active = true
ztaskzoosigntask.Active = true
zoneZooSign.Visible = true
elseif not Wherigo.NoCaseEquals(WeatherStationVariable,"Tornado") then
Wherigo.MessageBox{Text=[[Hmm, not quite the answer I was looking for, better read the sign again and then come talk to me.]],Media=zmediaRaccoon,}
end
end

function zoneZooSign:OnProximity()
-- #GroupDescription=zoo sign prox --
-- #Comment=zoo sign prox Comment --
zcharacterSquirrel.Visible = true
Wherigo.MessageBox{Text=[[OK, doing well so far, now this sign is very important, as it has the information you will need to complete this stop as well as the next two, so please read it carefully. When you are done, talk to the squirrel for your next question.]],Media=zmediaRangerTom,}
end

function zcharacterSquirrel:OnTalkTo()
-- #GroupDescription=squirrel talk --
-- #Comment=squirrel talk Comment --
Wherigo.GetInput(zinputzoosigninput)
end

function zinputzoosigninput:OnGetInput(input)
zoosignvariable = tonumber(input)
-- #GroupDescription=zoo sign input --
-- #Comment=zoo sign input Comment --
if   zoosignvariable == 249 then
ztaskzoosigntask.Complete = true
ztaskzoosigntask.Active = false
zoneWeatherStation.Visible = false
zoneWeatherStation.Active = false
zcharacterRaccoon.Visible = false
ztaskbeardentask.Active = true
Wherigo.MessageBox{Text=[[That's right! The CCC made improvements to many of our State Parks, some of which have stood the test of time and mother nature to this day. Now head over to the old bear den for your next task.]],Media=zmediaSquirrel,}
zoneBearCave.Active = true
zoneBearCave.Visible = true
elseif zoosignvariable ~= 249 then
Wherigo.MessageBox{Text=[[I'm sorry, better read the sign again, that's not the right answer]],Media=zmediaSquirrel,}
end
end

function zcharacterMommaBear:OnTalkTo()
-- #GroupDescription=bear talk --
-- #Comment=bear talk Comment --
Wherigo.GetInput(zinputbearcaveinput)
end

function zinputbearcaveinput:OnGetInput(input)
bearcavevariable = input
-- #GroupDescription=bear cave input --
-- #Comment=bear cave input Comment --
if   Wherigo.NoCaseEquals(bearcavevariable,"Suzie") then
ztaskbeardentask.Complete = true
ztaskbeardentask.Active = false
ztaskzooruintask.Active = true
zoneZooSign.Visible = false
zoneZooSign.Active = false
zcharacterSquirrel.Visible = false
zoneZooRuins.Active = true
zoneZooRuins.Visible = true
Wherigo.MessageBox{Text=[[That's right, those poor cubs were orphaned by a forest fire. As my friend Smokey says Only YOU can prevent forest fires, so please be careful! Now head on over to the ruins of the zoo pavillion for your next task.]],Media=zmediaBear,}
elseif not Wherigo.NoCaseEquals(bearcavevariable,"Suzie") then
Wherigo.MessageBox{Text=[[Not the answer I was looking for, check the sign again, and remember, spelling counts.]],Media=zmediaBear,}
end
end

function zoneZooRuins:OnProximity()
-- #GroupDescription=zoo ruins prox --
-- #Comment=zoo ruins prox Comment --
zcharacterOwl.Visible = true
Wherigo.MessageBox{Text=[[Well, here we are, the ruins of the zoo pavillion. We displayed many small aimals, fish, and even turtles here, some of the cages were hung from the ceiling or the sides. You can still see the remains of the walls and the tanks. Now, talk to the owl to get your next question.]],Media=zmediaRangerTom,}
end

function zcharacterOwl:OnTalkTo()
-- #GroupDescription=owl talk --
-- #Comment=owl talk Comment --
Wherigo.GetInput(zinputzooruinsinput)
end

function zinputzooruinsinput:OnGetInput(input)
zooruinsvariable = tonumber(input)
-- #GroupDescription=zoo ruins input --
-- #Comment=zoo ruins input Comment --
if   zooruinsvariable == 1933 then
ztaskzooruintask.Complete = true
ztaskzooruintask.Active = false
zoneBearCave.Visible = false
zoneBearCave.Active = false
zoneTrailSigns.Active = true
zoneTrailSigns.Visible = true
ztasktrailsigntask.Active = true
Wherigo.MessageBox{Text=[[That's right, the zoo opened on October 1st 1933 and was a very popular attraction. All the animals were released back to the wild at the end of each season. Now, head on up to the trail information sign where Ranger Tom will tell you what to do next.]],Media=zmediaowl,}
elseif zooruinsvariable ~= 1933 then
Wherigo.MessageBox{Text=[[No, I'm sorry but that's not quite right. I shouldnt do this, but If you promise not to tell Ranger Tom, I'll give you a hint. The last two numbers look like EE would in a mirror.]],Media=zmediaowl,}
end
end

function zoneBearCave:OnProximity()
-- #GroupDescription=bear cave prox --
-- #Comment=bear cave prox Comment --
zcharacterMommaBear.Visible = true
Wherigo.MessageBox{Text=[[OK, this is the halfway stop on our tour. Now you need to talk to Momma Bear.]],Media=zmediaRangerTom,}
end

function zoneTrailSigns:OnProximity()
-- #GroupDescription=trail sign prox --
-- #Comment=trail sign prox Comment --
zcharacterDeer.Visible = true
Wherigo.MessageBox{Text=[[OK, just one last stop before I show you where the cache is. This sign will tell you about two of the many trails in the park, one of which was bult at the same time as the zoo by the same CCC company. After you read the signs, talk to the deer for your question.]],Media=zmediaRangerTom,}
end

function zcharacterDeer:OnTalkTo()
-- #GroupDescription=deer talk --
-- #Comment=deer talk Comment --
Wherigo.GetInput(zinputtrailsigninput)
end

function zinputtrailsigninput:OnGetInput(input)
trailsignvariable = input
-- #GroupDescription=trail sign input --
-- #Comment=trail sign input Comment --
if   Wherigo.NoCaseEquals(trailsignvariable,"Red Jacket") then
ztasktrailsigntask.Complete = true
ztasktrailsigntask.Active = false
ztaskFinalTask.Active = true
zoneZooRuins.Active = false
zoneZooRuins.Visible = false
zoneFinalArea.Active = true
zoneFinalArea.Visible = true
zcharacterOwl.Visible = false
Wherigo.MessageBox{Text=[[That's right! Surprised that we had a ski jump here at the park? The trail, as well as the nearby area were named for the famous Native American leader as a way of honoring him. You should head over to the final zone, Ranger Tom will tell you how to find the cache when you get there.]],Media=zmediaDeer,}
elseif not Wherigo.NoCaseEquals(trailsignvariable,"Red Jacket") then
Wherigo.MessageBox{Text=[[Sorry, wrong trail, try the other one or check your spelling.]],Media=zmediaDeer,}
end
end

function zoneFinalArea:OnProximity()
-- #GroupDescription=final prox --
-- #Comment=final prox Comment --
Wherigo.MessageBox{Text=[[OK, now that you have completed the tour, it's time to tell you where the cache is. Before I do that though, after you find the cache, you MUST tell me the code word in the logbook to complete the cartridge. If you don't, you won't be able to unlock the cartridge. The cache is located inside a hollow spot under some bark on a fallen tree between the two trails. It's a fairly obvious spot to a geocacher. The code word is inside the front cover of the logbook, and on the inside of the lid]],Media=zmediaRangerTom,}
zcharacterRangerTom:MoveTo(zoneFinalArea)
zcharacterRangerTom.Visible = true
zcharacterRangerTom.Commands["GiveCodeWord"].Enabled = true
end

function zcharacterRangerTom:OnGiveCodeWord()
-- #GroupDescription=give code --
-- #Comment=give code Comment --
Wherigo.GetInput(zinputFinalInput)
end

function zinputFinalInput:OnGetInput(input)
FinalVariable = input
-- #GroupDescription=final input --
-- #Comment=final input Comment --
if   Wherigo.NoCaseEquals(FinalVariable,"Fancher") then
ztaskFinalTask.Complete = true
ztaskFinalTask.Active = false
zoneTrailSigns.Active = false
zoneTrailSigns.Visible = false
zcharacterDeer.Visible = false
cartWherigoASPOldZoo.Complete = true
Wherigo.MessageBox{Text=[[Good, you found the cache! Albert T Fancher was the first Chairman of the Allegany State Park Commission and left the park a gift in his will for improvements. Now when you click OK I'll save your cartridge so that it shows as completed, follow the directions on the cache page on how to upload your saved cartridge to unlock it and mark it as completed. If you were part of a group but didn't have a wherigo player yourself, email the code word to MickEMT through geocaching.com and let him know who had the wherigo player. I hope you enjoyed our tour, and have fun exploring the rest of the park. You can turn the wherigo player off now, your cartridge has been saved.]],Media=zmediaRangerTom,}
cartWherigoASPOldZoo:RequestSync()
zcharacterRangerTom.Visible = false
elseif not Wherigo.NoCaseEquals(FinalVariable,"Fancher") then
Wherigo.MessageBox{Text=[[Hmm, better check that gain, the code word is on the inside of the front cover and inside the lid.]],Media=zmediaRangerTom,}
end
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartWherigoASPOldZoo
